import java.io.*;

/**
 * Classe che si occupa della gestione dell'io dell'applicazione, mostra
 * i messaggi a video, sulla consolle
 * @author Letizia Cheng Cheng Sun
 * @version 1.0
 */
public class ShowMessagePrompt implements IShowMessage, Serializable{
	
	/**
	 * Metodo che mostra a video un messaggio
	 * @param mess messaggi da visualizzare
	 */
	public void println(Msg mess){
			System.out.println(mess);
	}
	
	/**
	 * Metodo che mostra una riga vuota a video
	 *
	 */
	public void println(){
		System.out.println();
	}
	
	/**
	 * Metodo che mostra a video la stringa in ingresso
	 * aggiungendo poi "\n"
	 * @param s stringa da mostrare a video
	 */
	public void println(String s){
		System.out.println(s);
	}
	
	/**
	 * Metodo che mostra la stringa a video senza il nuova linea alla fine
	 * @param s stringa da mostrare a video
	 */
	public void print(String s){
		System.out.print(s);
	}
}
